<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class CategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
                'name_ar'                  => 'required|string',
                "name_en"                => "required|string",
                "photo"                => "nullable|mimes:jpg,gif,jpeg,png,tiff,svg",

            ];
        }
        return [
            'name_ar'                  => 'required|string',
            "name_en"                => "required|string",
            "photo"                => "required|mimes:jpg,gif,jpeg,png,tiff,svg",
        ];
    }
}
