<?php

namespace App\Http\Requests\Admin;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;

class CouponRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
//                'code'                  => 'required||unique:coupons',
                "from_date"                => "nullable",
                "to_date"                => "nullable|after:from_date",
                "percentage"                => "required|numeric",
                "available_number"                => "nullable|numeric",
                "user_id"                => "required",

            ];
        }


        return [
            'code'                  => 'required||unique:coupons',
            "from_date"                => "nullable|after_or_equal:".Carbon::now()->format('Y-m-d'),
            "to_date"                => "nullable|after:from_date",
            "percentage"                => "required|numeric",
            "available_number"                => "nullable|numeric",
            "user_id"                => "required",
        ];
    }
}
