<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class PaymentMethodRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
                'name'                  => 'required|array',
                "name.*"                => "required|string",
                "method"                => "required_if:type,visa",
                "currency"                => "required_if:type,visa",
                'photo' =>'nullable|mimes:jpg,gif,jpeg,png,tiff'
            ];
        }


        return [
            'name'                  => 'required|array',
            "name.*"                => "required|string",
            "photo"                => "required|mimes:jpg,gif,jpeg,png,tiff",
            "method"                => "required_if:type,visa",
            "currency"                => "required_if:type,visa",
        ];
    }
}
