<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if( $this->method() == 'PATCH' ) {

            return [
                'about'                  => 'required|array',
                "about.*"                => "required|string",
                'terms'                  => 'required|array',
                "terms.*"                => "required|string",
                "email"                => "required|string|email",
                "phone"                => "required",

                "sms_url"                => "required",
                "sms_username"                => "required",
                "sms_password"                => "required",
                "sms_sender"                => "required",
                'snapchat'=>'required',
                'instagram'=>'required',
                'outside_price'=>'required',
                'minimum_pull'=>'required|numeric',


            ];
        }
        return [
            'about'                  => 'required|array',
            "about.*"                => "required|string",
            'terms'                  => 'required|array',
            "terms.*"                => "required|string",
            "email"                => "required|string|email",
            "phone"                => "required",

            "sms_url"                => "required",
            "sms_username"                => "required",
            "sms_password"                => "required",
            "sms_sender"                => "required",
            'snapchat'=>'required',
            'instagram'=>'required',
            'outside_price'=>'required',
            'minimum_pull'=>'required|numeric',
        ];
    }
}
