<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SliderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        if( $this->method() == 'PATCH' ) {

            return [
//                'name'                  => 'required|array',
//                "name.*"                => "required|string",
                "link_type"                => "required",
                "link"                => "required_if:link_type,other",
                "category_id"                => "required_if:link_type,category",
                "product_id"                => "required_if:link_type,product",
                "photo"                => "nullable|mimes:jpg,gif,jpeg,png,tiff",
                "photo_en"                => "nullable|mimes:jpg,gif,jpeg,png,tiff",

            ];
        }
        return [
//            'name'                  => 'required|array',
//            "name.*"                => "required|string",
            "link_type"                => "required",
            "link"                => "required_if:link_type,other",
            "category_id"                => "required_if:link_type,category",
            "product_id"                => "required_if:link_type,product",
            "photo"                => "required|mimes:jpg,gif,jpeg,png,tiff",
            "photo_en"                => "required|mimes:jpg,gif,jpeg,png,tiff",
        ];
    }
}
