<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if( $this->method() == 'PATCH' ) {

            return [
                'phone' =>['required', 'regex:/(05)[0-9]{8}/','size:10','unique:users,phone,'. $this->user->id],
                'name'                  => 'required|max:255',
                'email'                  => 'nullable|string|email|max:255|unique:users,email,'.$this->user->id,

            ];
        }
        return [

            'phone' =>['required', 'regex:/(05)[0-9]{8}/','size:10','unique:users'],
            'name'                  => 'required|max:255',
            'email'                  => 'nullable|string|email|max:255|unique:users',
            'password'              => 'required|min:6',
        ];
    }
}
