<?php

namespace App\Http\Requests\Api;

use App\Http\Requests\RequestApiParent;

class EditPostRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'photo'                 => 'nullable|mimes:jpg,gif,jpeg,png,tiff,svg',
            'description'           =>'required|string',
            'open_comments'           =>'required|in:not_available,available',
            'post_id'           =>'required|exists:posts,id',

        ];
    }
}
