<?php

namespace App\Http\Requests\Api;

use App\Http\Requests\RequestApiParent;

class RegisterRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone' =>['required', 'regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
            'name'                  => 'required|max:255',
            'email'                  => 'nullable|string|email|max:255|unique:users',
            'device_token'          => 'required',
            'device_identifier'           => 'required',
            'password'              => 'required|min:6',
            'user_type'              => 'required|in:dealer,user',
        ];
    }
}
