<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\RequestApiParent;

class AddAddressRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone' =>['required', 'regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
            'street_name'           => 'required|string',
            'building_number'           => 'required|string',
            'lat'   => 'required|string',
            'lng'   => 'required|string',
            'floor_number'   => 'nullable|string',
            'apartment_number'   => 'nullable|string',
            'description'   => 'required|string',
        ];
    }
}
