<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\RequestApiParent;

class EditAddressRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'phone' =>['nullable', 'regex:/^(009665|9665|\+9665|05|5)(5|0|3|6|4|9|1|8|7)([0-9]{7})$/'],
            'street_name'           => 'nullable|string',
            'building_number'           => 'nullable|string',
            'lat'   => 'nullable|string',
            'lng'   => 'nullable|string',
            'floor_number'   => 'nullable|string',
            'apartment_number'   => 'nullable|string',
            'description'   => 'nullable|string',
            'address_id'          => 'nullable|exists:addresses,id',
        ];
    }
}
