<?php

namespace App\Http\Requests\Api\User;

use App\Http\Requests\RequestApiParent;

class EditProfileRequest extends RequestApiParent
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name'                  => 'nullable|max:255',
            'email'                  => 'nullable|string|email|max:255|unique:users,email,'.\request()->user()->id,
            'gender'              => 'nullable|string|in:female,male',
            'birthday'              => 'nullable|date_format:"Y-m-d"',
        ];
    }
}
