<?php

namespace App\Http\Resources;


use App\Models\OrderProduct;
use App\Models\PaymentMethod;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $data=[
            'id' => $this->id,
            'address' => [
                'name'=>$this->name,
                'phone'=>$this->phone,
                'notes'=>$this->notes,
                'city_name'=>$this->city->name[app()->getLocale()],
                'region_name'=>$this->region->name[app()->getLocale()],

            ],
            'payment_method' => PaymentMethod::find($this->payment_method)->name[app()->getLocale()],
            'status'=> getOrderType($this->status),
            'status_id'=> $this->status,
            'order_date'=> Carbon::parse($this->created_at)->isoFormat('MMMM Do YYYY, hh:mm a'),
            'orders' => OrderProductDetailsResource::collection(OrderProduct::whereOrderId($this->id)->get()),
            'coupon'=>$this->coupon,
            'products_total'=>$this->products_total,
            'shipping_cost'=>$this->shipping_cost,
            'total_after_coupon'=>$this->total_after_coupon,
            'all_total'=> $this->all_total ,
            'delivered'=>$this->status == "done" ? 1 : 0,
            'whatsapp_numbner'=>settings()->whatsapp

        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
