<?php

namespace App\Http\Resources;


use App\Models\Product;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderProductDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        if ($this->productable_type == "App\Product"){
            $product = Product::withTrashed()->find($this->product_id);
            $title = $product->title[app()->getLocale()];
            $image = $product->images()->first()->image;
            $height  = $product->images()->first()->height;
            $width  = $product->images()->first()->width;
        }else{
            $product = Product::withTrashed()->find($this->product_id);
            $title = $product->title;
            $image = $product->images()->first()->image;
            $height  = $product->images()->first()->height;
            $width  = $product->images()->first()->width;
        }

        $data= [
            'id' => $this->id,
            'product_id' => $this->product_id,
            'image_path'=>'/uploads/products/',
            'image' => $image,
            'title'=>$title,
            'height'=>$height,
            'width'=>$width,
            'price'=>$this->price ,


        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
