<?php

namespace App\Http\Resources\User;

use Illuminate\Http\Resources\Json\JsonResource;

class AddressResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $data= [
            'id' => $this->id,
            'phone'  => $this->phone,
            'street_name'  => $this->street_name,
            'building_number'  => $this->building_number,
            'lat'  => $this->lat,
            'lng'  => $this->lng,
            'floor_number'  => $this->floor_number,
            'apartment_number'  => $this->apartment_number,
            'description'  => $this->description,
            'default_address'  => (int)$this->default_address,
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
