<?php

namespace App\Http\Resources\User;

use App\Models\Category;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $counts =Category::where('parent_id',$this->id)->count();
        return [
            'id' => $this->id,
            'image_path'=>'/uploads/categories/',
            'image' => $this->image,
            'height' => $this->height,
            'width' => $this->width,
            'name'  => $this->name[app()->getLocale()],
            'has_sub_category'=> $counts > 0 ,
            'is_main_category' => $this->parent_id == null ,
        ];
    }
}
