<?php

namespace App\Http\Resources\User;

use Carbon\CarbonInterface;
use Illuminate\Http\Resources\Json\JsonResource;

class CommentsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {


        $data= [
            'id'  => $this->id,
            'comment'  => $this->comment,
            'user'  => [
                'id'=>$this->user_id,
                'name'=>$this->user->name,
                'image_path'=>'/uploads/users/',
                'image'=>$this->user->image,
            ],
//            'created_at'=>$this->created_at->format('d/m/y'),
            'created_at'=>$this->created_at->diffForHumans(),
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
