<?php

namespace App\Http\Resources\User;

use App\Models\Favorite;
use App\Models\Product;
use App\Models\ProductRate;
use Illuminate\Http\Resources\Json\JsonResource;
use JWTAuth;

class ProductDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {
        $images = [];
        foreach ($this->images()->get() as $data){
            array_push($images , ['id'=>$data->id ,
                'image'=>$data->image,
                'image_path'=>'/uploads/products/',
                'height'  => $data->height,
                'width'  => $data->width,
            ]);
        }


        $data= [
            'id'  => $this->id,
            'title'  =>$this->type == "gift"? $this->title :$this->title[app()->getLocale()],
            'description'  =>$this->type == "gift" ?  $this->description : $this->description[app()->getLocale()],
            'description_string'  =>$this->type == "gift" ? strip_tags($this->description)  : strip_tags($this->description[app()->getLocale()]) ,
            'images'=>$images,
            'price'=>$this->price,
            'after_discount'=>$this->discount != null ? $this->after_discount : 0,
            'discount'=>$this->discount,
            'has_discount'=> $this->discount ?  true : false,
            'user'  => [
                'id'=>$this->user_id,
                'name'=>$this->user->name,
                'image_path'=>'/uploads/users/',
                'image'=>$this->user->image,
                'height' => $this->user->height,
                'width' => $this->user->width,
            ],
            'fav'=> \request()->header('Authorization') && JWTAuth::parseToken()->authenticate() ? (Favorite::whereUserId(JWTAuth::parseToken()->authenticate()->id)->whereProductId($this->id)->first()? 1 : 0):0,
            'rates'=>(int) ProductRate::where('to_user',$this->user_id)->avg('rate'),
            'rates_total'=>(int) ProductRate::where('to_user',$this->user_id)->count(),
            'related_products'=> HomeProductResource::collection( Product::whereType('product')->where('category_id',$this->category_id)->where('sub_category_id',$this->sub_category_id)->where('id','!=',$this->id)->whereActive(1)->whereStatus(0)->get()),

        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
