<?php

namespace App\Http\Resources\User;

use App\Models\Category;
use Illuminate\Http\Resources\Json\JsonResource;

class SliderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */


    public function toArray($request)
    {

        $region_id= $request->header('region-id');

        $data= [
            'id' => $this->id,
            'image_path'=>'/uploads/sliders/',
            'image' =>app()->getLocale() == "ar" ? $this->image : $this->image_en,
            'height' =>app()->getLocale() == "ar" ? $this->height : $this->height_en,
            'width' =>app()->getLocale() == "ar" ? $this->width : $this->width_en,
            'link_type'  => $this->link_type,
            'category_id'  => $this->category_id,
            'main_category'  => $this->link_type == "category" ? (Category::find($this->category_id)->parent_id == null ? (Category::where('parent_id',$this->category_id)->count() > 0 ? 1 : 0) : 0) : 0 ,
            'product_id'  => $this->product_id,
            'link'  => $this->link,
        ];
        return   array_filter($data, function($value) {
            return $value !== null && $value !== '' && $value !== "" ;
        });
    }
}
