<?php

namespace App\Jobs;

use App\Mail\CouponSend;
use App\Models\User;
use App\Models\UserCoupon;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Mail;

class SendMailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $data;


    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        //
        $users  = User::where('user_type','user')->get();
        foreach ($users as $data){
            $all = [
                'code'  =>$this->data['code'] ,
                'from_date'       => $this->data['from_date'],
                'to_date'   => $this->data['to_date'],
                'number'   => $this->data['available_number'],
            ];
            if (! UserCoupon::where('coupon_id',$this->data['id'])->where('user_id',$data->id)->first()){
                UserCoupon::create([
                    'user_id'=>$data->id,
                    'coupon_id'=>$this->data['id'],

                ]);
            }

            $result = filter_var( $data->email, FILTER_VALIDATE_EMAIL );
            if ($result){
                $emailArray = explode("@", $data->email);

                if (checkdnsrr(array_pop($emailArray), "MX")) {
                    if ($data->email){
                        Mail::to($data->email)->send(new CouponSend($all));

                        if( count(Mail::failures()) > 0 ) {
                            Mail::to($data->email)->send(new CouponSend($all));

                            if( count(Mail::failures()) > 0 ) {
                                Mail::to($data->email)->send(new CouponSend($all));
                            }
                        }
                    }
                }

            }



        }
    }
}
