<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderSend extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data         = $data;
        $this->siteName     = "Nosq";
        $this->siteEmail    = settings()->email;
        $this->sitePhone    = settings()->phone;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(settings()->email, "info@nosq.app" )
            ->view('emails.order')
            ->subject($this->data['status_text'])
            ->with([
                'status'  => $this->data['status'],
                'url'   => $this->data['url'],
                'lang'   => $this->data['lang'],
                'order_id'   => $this->data['order_id'],
                'first'   => $this->data['first'],
                'second'   => $this->data['second'],
                'siteName'      => $this->siteName,
                'siteEmail'     => $this->siteEmail,
                'sitePhone'     => $this->sitePhone,
            ]);
    }
}
