<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ReplySubscription extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data         = $data;
        $this->siteName     = "info@nosq.app";
        $this->siteEmail    = settings()->email;
        $this->sitePhone    = settings()->phone;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(settings()->email, "info@nosq.app" )
            ->view('emails.subscription_reply')
            ->subject($this->data['headingTitle'])
            ->with([
                'headingTitle'  => $this->data['headingTitle'],
                'mailMessage'   =>  $this->data['message'],
                'siteName'      => $this->siteName,
                'siteEmail'     => $this->siteEmail,
                'sitePhone'     => $this->sitePhone,
            ]);
    }
}
