<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;

class Admin extends Authenticatable
{
    use HasFactory;
    use Notifiable;

    protected $fillable = [
        'name', 'email', 'password', 'phone','image','device_token'
    ];


    protected $hidden = [
        'password', 'remember_token',
    ];


    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::make($value);
    }


    public function hasPermission($permission) {

        $adminPermissions = $this->permissions;

        foreach ($adminPermissions as $adminPermission) {

            if( $permission == $adminPermission->name ) {
                return true;
            }
        }
        return false;
    }


    public function permissions() {

        return $this->belongsToMany(Permission::class)->withTimestamps();
    }

    public function roles() {

        return $this->belongsToMany(Role::class)->withTimestamps();
    }

    public function rolePermissions(){

        return $this->hasManyThrough(Permission::class, Role::class);
    }


    public function sendPasswordResetNotification($token)
    {
        $this->notify(new AdminResetPasswordNotification($token));
    }
}





