<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Chat extends Model
{
    use HasFactory;
    protected $fillable=[
        'sender_id',
        'senderable_type',
        'room_id',
        'gift_id',
        'giftable_type',
        'message',
        'file',
        'seen',
        'duration',
        'type',
    ];
    public function room()
    {
        return $this->belongsTo(Room::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class,'sender_id','id');
    }
}
