<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'user_type',
        'phone',
        'active',
        'approved',
        'confirm_code',
        'language',
        'gender',
        'birthday',
        'image',
        'app_percentage',
        'description',
        'wallet',
        'height',
        'width'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()

    {

        return $this->getKey();

    }

    public function getJWTCustomClaims()

    {

        return [];

    }
    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = Hash::make($value);
    }
    public function posts() {

        return $this->hasMany(Post::class);
    }
    public function orders() {

        return $this->hasMany(Order::class);
    }
    public function regions()
    {
        return $this->belongsToMany(Region::class)->withTimestamps();
    }
    public function rates()
    {
        return $this->hasMany(ProductRate::class,'user_id');
    }
    public function carts()
    {
        return $this->hasMany(Cart::class,'user_id');
    }
    public function favorites()
    {
        return $this->hasMany(Favorite::class,'user_id');
    }
}
