<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Role;
use App\Models\Admin;

class CreatePermissionRoleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('permission_role', function (Blueprint $table) {
            $table->bigInteger('permission_id')->unsigned();
            $table->bigInteger('role_id')->unsigned();
            $table->timestamps();

            $table->foreign('permission_id')
                ->references('id')->on('permissions')
                ->onDelete('cascade');

            $table->foreign('role_id')
                ->references('id')->on('roles')
                ->onDelete('cascade');
        });
        //////////////////**************************************//////////////////

        //generate-permissions-for-this-table..
        Permission::generatePermissions('roles');
        Permission::generatePermissions('users');
        Permission::generatePermissions('admins');
        Permission::generatePermissions('permissions');


        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );
        $adminRole->admins()->sync( [0 => 1] );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );

//////////////////**************************************//////////////////


        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('countries');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permission_role');
    }
}
