<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Admin;
use App\Models\Role;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->bigInteger('user_id')->unsigned()->nullable();
            $table->bigInteger('category_id')->unsigned()->nullable();
            $table->bigInteger('sub_category_id')->nullable()->unsigned();
            $table->double('discount')->nullable();
            $table->double('price')->nullable();
            $table->double('after_discount')->nullable();
            $table->longText('description')->nullable();
            $table->enum('range',['outside','inside'])->nullable();


            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onDelete('cascade');
            $table->foreign('sub_category_id')
                ->references('id')->on('categories')
                ->onDelete('cascade');
            $table->foreign('category_id')
                ->references('id')->on('categories')
                ->onDelete('cascade');
            $table->timestamps();
        });
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('products');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
