<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Permission;
use App\Models\Admin;
use App\Models\Role;

class CreatePaymentMethodsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->enum('type',['visa','cash','transfer'])->nullable();
            $table->tinyInteger('status')->default(false)->nullable();
            $table->string('icon')->nullable();
            $table->enum('currency',['SAR','EGP','USD'])->nullable();
            $table->enum('method',['src_card','src_eg.fawry','src_sa.mada','src_bh.benefit'])->nullable();

            $table->timestamps();
        });
        \App\Models\PaymentMethod::create([
            'type'=>"cash",
            'status'=>1,
            "icon"=>"paymentMethods_16025923515298.png",
            'name'=>['ar'=>"الدفع كاش عند الاستلام ", 'en'=> 'cash']
        ]);
        \App\Models\PaymentMethod::create([
            'type'=>"visa",
            'status'=>1,
            'method'=>"src_card",
            "currency"=>"SAR",
            "icon"=>"paymentMethods_16019737241490.png",
            'name'=>['ar'=>"بطاقة الائتمان ", 'en'=> 'online']
        ]);
        \App\Models\PaymentMethod::create([
            'type'=>"transfer",
            'status'=>1,
            "icon"=>"paymentMethods_16021729940472.png",
            'name'=>['ar'=>"تحويل بنكي", 'en'=> 'bank Transfer']
        ]);
        //****************************************************//
        //**************** CREATE-PERMISSIONS ****************//
        //****************************************************//

        //generate-permissions-for-this-table..
        Permission::generatePermissions('payment_methods');

        //add-these-permissions-to-admin-role(first_one)..
        $adminRole = Role::where('id', 1)->first();
        $adminRole->permissions()->sync( Permission::all()->pluck('id') );

        //add-these-permissions-to-admin-user..
        Admin::where('id', 1)->first()->permissions()->sync( Permission::all()->pluck('id') );
        //****************************************************//
        //***************** END-PERMISSIONS ******************//
        //****************************************************//
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
}
