<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->unsigned();
            $table->bigInteger('product_id')->nullable();
            $table->string('productable_type')->nullable();
            $table->string('coupon')->nullable();
            $table->string('coupon_id')->nullable();
            $table->bigInteger('region_id')->unsigned()->nullable();
            $table->bigInteger('city_id')->unsigned()->nullable();
            $table->enum('range',['outside','inside'])->nullable();
            $table->double('price')->nullable();
            $table->double('count')->nullable();
            $table->double('total')->nullable();
            $table->double('after_discount')->nullable();


            $table->foreign('city_id')
                ->references('id')->on('regions')
                ->onDelete('cascade');
            $table->foreign('region_id')
                ->references('id')->on('regions')
                ->onDelete('cascade');
            $table->foreign('user_id')
                ->references('id')->on('users')
                ->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('carts');
    }
}
