
<div class="form-body">
    <div class="form-group">
        <label for="name" class="col-lg-3 control-label">@lang('messages.name')
                <span class="text-danger">*</span>
        </label>
        <div class="col-lg-9">
            <input id="name" name="name" value="{{ isset($admin) ? $admin->name : old('name') }}" type="text" class="form-control" placeholder="{{trans('messages.name')}}">
        </div>
    </div>

    <div class="form-group">
        <label for="email" class="col-lg-3 control-label">@lang('messages.email')
                <span class="text-danger">*</span>
        </label>
        <div class="col-lg-9">
            <input id="email" name="email" value="{{ isset($admin) ? $admin->email : old('email') }}" type="email" class="form-control phone-text" placeholder="{{trans('messages.email')}}">
        </div>
    </div>

    <div class="form-group">
        <label for="phone" class="col-lg-3 control-label">@lang('messages.phone')

        </label>
        <div class="col-lg-9">
            <input id="phone" name="phone" value="{{ isset($admin) ? $admin->phone : old('phone') }}" type="text" class="form-control phone-text" placeholder="{{trans('messages.phone')}}">
        </div>
    </div>

    <div class="form-group">
        <label for="roles" class="col-3 col-form-label">@lang('messages.Supervisory_groups')
            <span class="text-danger">*</span>
        </label>

        <div class="col-lg-9">
            <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="roles" name="roles">
                <option value>@lang('messages.choose_group')</option>
                @foreach( $roles as $role)
                    <option value="{{ $role->id }}" {{ isset($admin) ? $admin->roles[0]->id == $role->id ? "selected" : '' : old("roles") == $role->id ? "selected" : ""  }}>{{ $role->name }}</option>
                @endforeach
            </select>
        </div>
    </div>

    @if( !isset($admin) )
        <div class="form-group">
            <label for="password" class="col-lg-3 control-label">@lang('messages.password')
                    <span class="text-danger">*</span>
            </label>
            <div class="col-lg-9">
                <input id="password" name="password" type="password" class="form-control" placeholder="{{trans('messages.password')}}">
            </div>
        </div>

        <div class="form-group">
            <label for="password_confirm" class="col-lg-3 control-label">@lang('messages.confirm_password')
                    <span class="text-danger">*</span>
            </label>
            <div class="col-lg-9">
                <input id="password_confirm" name="password_confirm" type="password" class="form-control" placeholder="{{trans('messages.confirm_password')}}">
            </div>
        </div>
    @endif

</div>
<div class="form-group mb-0 justify-content-end row">
    <button type="submit" class="btn btn-info waves-effect waves-light"> @lang('messages.save')</button>
</div>
