@extends('admin.layouts.master')

@section('title')
    اعلانات المنتجات
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.ads.index') }}">اعلانات المنتجات </a></li>
                        <li class="breadcrumb-item active">اعلانات المنتجات</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع اعلانات المنتجات </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">اعلانات المنتجات </h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th> العنوان</th>
                            <th> مكان الاعلان</th>
                            <th> نوع الرابط</th>
                            <th> الرابط</th>
                            <th> الصورة</th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td>{{ $value->title['ar'] }}</td>

                                    <td class="no_dec">
                                    <span style="background-color: {{ $value->color  }};"> {{getAdType($value->type)}} </span>
                                    </td>
                                    <td class="no_dec">

                                        <span style="background-color: {{ $value->color  }};"> {{getLinkType($value->link_type)}} </span>
                                    </td>
                                    <td class="no_dec">
                                        @if($value->link_type == "category")
                                            <span style="background-color: {{ $value->color  }};"> {{ $value->category->name['ar'] }} </span>
                                        @elseif($value->link_type == "product")
                                            <span style="background-color: {{ $value->color  }};"> {{ $value->product->name['ar'] }} </span>
                                        @elseif($value->link_type == "external_link")
                                            <span style="background-color: {{ $value->color  }};"> {{ $value->link }} </span>
                                        @else
                                            لا يوجد
                                        @endif


                                    </td>
                                    <td>
                                        <img class="rounded mr-1" height="60"  src="{{ URL::asset('uploads/sliders/'.$value->image) }}">
                                    </td>

                                    <td>
                                            <div class="btn-group mb-2">
                                                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations') </button>
                                                <div class="dropdown-menu">


                                                    @can('edit_ads', $value)

                                                        <a class="dropdown-item" href="{{ route('admin.ads.edit', $value->id) }}">
                                                            @lang('messages.edit')<i class="la la-edit options-style"></i>
                                                        </a>

                                                    @endcan

                                                </div>
                                            </div>


                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')

    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>
    <script>
        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );

    </script>

@endsection
