@extends('admin.layouts.master')

@section('title')
    @lang('messages.view_all_banks')
@endsection



@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.banks.index') }}">@lang('messages.banks')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.view_all_banks')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.view_all_banks')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">
                <img src="{{  URL::asset('uploads/banks/'.$bank->image) }}" class="rounded mr-1" height="60" width="300"  alt="{{ $bank->bank_name[App::getLocale()] }}" class="rounded-circle avatar-lg img-thumbnail"
                >

                <h4 class="mb-2"> {{ $bank->bank_name[App::getLocale()] }} </h4>





                <div class="text-left mt-3">

                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.account_name') :</strong> <span class="ml-2">{{$bank->name[App::getLocale()]}}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.account_number') :</strong> <span class="ml-2">{{$bank->account_number}}</span></p>



                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.Date_added') :</strong> <span class="ml-2 badge badge-info ">{{ $bank->created_at->format('Y-m-d g:i A') }}</span></p>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->

    </div>


@endsection
@section('scripts')
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
