@extends('admin.layouts.master')

@section('title')
    التحويلات البنكية
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.banksTransfer.index','type=waiting') }}">التحويلات البنكية</a></li>
                        <li class="breadcrumb-item active"> التحويلات البنكية تم تأكيدها </li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع التحويلات البنكية تم تأكيدها </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">التحويلات البنكية تم تأكيدها </h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>

                            <th> رقم الطلب </th>
                            <th> مبلغ التحويل </th>
                            <th> اسم البنك (تم التحويل من خلاله) </th>
                            <th> اسم المستفيد </th>
                            <th>  اسم البنك </th>
                            <th>  صورة ايصال التحويل </th>
                            <th>  رقم الحساب </th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>

                                    <td class="no_dec">
                                        <a href="{{ route('admin.orders.orders-details', $value->order_id) }}"> {{ $value->order_id }} </a>

                                    </td>
                                    <td class="no_dec">
                                        {{ $value->balance }}

                                    </td>
                                    <td class="no_dec">
                                        <a href="{{ route('admin.banks.show', $value->bank_id) }}"> {{ \App\Models\Bank::find($value->bank_id)->bank_name['ar']  }} </a>

                                    </td>
                                    <td>
                                        {{$value->user_name}}
                                    </td>
                                    <td>
                                        {{$value->bank_name}}
                                    </td>
                                    <td>
                                        <a href="{{ URL::asset('uploads/transfers/'.$value->image) }}" target="_blank">
                                            <img class="rounded mr-1" height="60"  src="{{ URL::asset('uploads/transfers/'.$value->image) }}">
                                        </a>
                                    </td>
                                    <td>
                                        {{$value->account_number}}
                                    </td>

                                    <td>
                                        <span class="badge badge-success">تم تأكيد التحويل</span>
                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')

    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>


@endsection
