@extends('admin.layouts.master')

@section('title')
    تعديل كوبونات الخصم
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.coupons.index') }}">كوبونات الخصم</a></li>
                        <li class="breadcrumb-item active">تعديل كوبونات الخصم</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل كوبونات الخصم</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($coupon, ['method' => 'PATCH', 'url' => route('admin.coupons.update', $coupon->id),'class' => 'form-horizontal form-row-seperated', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') كوبونات الخصم</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>


                <div class="card-box">
                        @include('admin.coupons._form')

                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
    <script>

        function add_code() {

            var random = Math.random().toString(36).substring(2, 5).toUpperCase() + Math.random().toString(36).substring(2, 5).toUpperCase();
            document.getElementById('code').value = random;

        }

        $(document).ready(function() {
            $('select[name="user_id[]"]').on('change', function() {
                var id = $(this).val();
                if(id ==''){
                    $('#available_number').empty();
                }else if(id == 'all'){
                    $('#available_number').empty();

                    $('#available_number').append('<div class="form-group row mb-3"><label for="available_number" class="col-md-3 col-form-label">عدد مرات الاستخدام  </label><div class="col-9"><input type="number" min="1" id="available_number"  name="available_number" class="form-control" placeholder="عدد مرات الاستخدام" value="" parsley-trigger="change" required  >');


                    $('#available_number').append('</div></div>');

                }else if(id.length > 1){
                    $('#available_number').empty();

                    $('#available_number').append('<div class="form-group row mb-3"><label for="available_number" class="col-md-3 col-form-label">عدد مرات الاستخدام  </label><div class="col-9"><input type="number" min="1" id="available_number"  name="available_number" class="form-control" placeholder="عدد مرات الاستخدام" value="" parsley-trigger="change" required  >');


                    $('#available_number').append('</div></div>');

                }else if(id.length == 1 && id !== 'all'){
                    $('#available_number').empty();
                }




            });

        });
    </script>
@endsection
