@extends('admin.layouts.master')

@section('title')
    عرض تفاصيل المتجر
@endsection



@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.dealers.index') }}">المتاجر</a></li>
                        <li class="breadcrumb-item active">عرض جميع المتاجر</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض تفاصيل المتجر</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">

                <h4 class="mb-2"> {{ $dealer->name }} </h4>


                <div class="text-left mt-3">


                    <p class="text-muted mb-2 font-13"><strong>اسم المتجر :</strong> <span class="ml-2">{{$dealer->name}}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.phone') :</strong><span class="ml-2">{{ $dealer->phone }}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.email') :</strong> <span class="ml-2 ">{{ $dealer->email }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>اجمالي عدد المبيعات :</strong> <span class="ml-2 ">{{ $sales_number }} </span></p>
                    <p class="text-muted mb-2 font-13"><strong>اجمالي قيمة المبيعات :</strong> <span class="ml-2 ">{{ $sales_price }} ريال</span></p>
                    <p class="text-muted mb-2 font-13"><strong>عمولة التطبيق :</strong> <span class="ml-2 ">{{ $app_price }} ريال</span></p>
                    <p class="text-muted mb-2 font-13"><strong>رصيد التاجر المتاح :</strong> <span class="ml-2 ">{{ $dealer->wallet }} ريال</span></p>
                    <p class="text-muted mb-2 font-13"><strong>نسبة التطبيق :</strong> <span class="ml-2 ">{{ $dealer->app_percentage }} %</span></p>
                    <p class="text-muted mb-2 font-13"><strong>التفاصيل :</strong> <span class="ml-2 ">{{ $dealer->description }}</span></p>
                    <p class=" mb-2 font-13"><strong>@lang('messages.Activation') :</strong>  <span class="ml-2 badge badge-pill {{ $dealer->active ? "badge-secondary" : "badge-light-secondary" }}">
                        {{ $dealer->active ? trans('messages.Activate') : trans('messages.Deactivate') }}
                    </span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.Date_added') :</strong> <span class="ml-2 badge badge-info ">{{ $dealer->created_at->format('Y-m-d g:i A') }}</span></p>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">

                <h4 class="mb-2"> المدن والمناطق </h4>


                <div class="text-left mt-3">
                    @foreach($cities as $value)
                        <h4 class="mb-2"> {{ $value->name['ar'] }} </h4>


                        @foreach($dealer->regions()->where('regions.parent_id',$value->id)->get() as $value2)
                        <p class="text-muted mb-2 font-13"><strong>- {{ $value2->name['ar'] }}</strong></p>

                        @endforeach

                    @endforeach
                        <hr>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->


    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">المنتجات</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th> الاسم </th>
                            <th> اسم التاجر </th>
                            <th>القسم الرئيسي</th>
                            <th> الخصم % </th>
                            <th> التمييز </th>
                            <th> حالة المنتج </th>
                            <th> عدد المبيعات </th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td class="no_dec">
                                        <a class="dropdown-item" href="{{ route('admin.products.show', $value->id) }}">
                                            {{$value->title['ar'] }}
                                        </a>
                                    </td>
                                    <td class="no_dec">
                                        <a class="dropdown-item" href="{{ route('admin.dealers.show', $value->user_id) }}">
                                            {{$value->user->name }}
                                        </a>
                                    </td>
                                    <td class="no_dec">
                                        {{$value->category->name['ar']}}
                                    </td>
                                    <td class="no_dec">
                                        {{ $value->discount ? $value->discount : '--' }}
                                    </td>
                                    <td>
                                        <span class="badge  badge-pill {{ $value->special == "1" ? "badge-secondary" : "badge-light-secondary" }}"> {{ $value->special == "1" ? trans('messages.special') : trans('messages.not_special') }} </span>
                                    </td>
                                    <td class="no_dec">
                                        @can('activate_products', $value)
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" value="{{$value->active ? 0 : 1}}"  data_str="{{ $value->active ? "تم تعطيل المنتج" : "تم تفعيل المنتج"}}" @if($value->active == 1) checked @endif onclick="enableProduct({{$value->id}})" id="customSwitch1{{$value->id}}">
                                                <label class="custom-control-label" for="customSwitch1{{$value->id}}">مفعل/معطل</label>
                                            </div>
                                        @else
                                            <span class="badge badge-light-danger">
                                                 <i class=" la la-close"></i> @lang('messages.You_do_not_have_permission')
                                             </span>
                                        @endif
                                    </td>
                                    <td>{{$value->sold}}</td>
                                    <td>
                                        <div class="btn-group mb-2">
                                            <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations') </button>
                                            <div class="dropdown-menu">

                                                @can('show_products', $value)

                                                    <a class="dropdown-item" href="{{ route('admin.products.show', $value->id) }}">
                                                        @lang('messages.view')<i class="la la-eye options-style"></i>
                                                    </a>

                                                @endcan
                                                <a class="dropdown-item change_status" data="{{ $value->id }}" data_name="{{ $value->title['ar']  }}" data_str="{{ $value->special == "1" ? trans('messages.not_specialize') : trans('messages.specialize') }}" data_status="{{ $value->special == "1" ? 0 : 1 }}">
                                                    {{ $value->special == "1" ? trans('messages.not_specialize') : trans('messages.specialize') }} <i class="la la-{{ $value->special == "1" ? 'close' : 'check' }} options-style"></i>
                                                </a>

                                                @can('edit_products', $value)

                                                    <a class="dropdown-item" href="{{ route('admin.products.edit', $value->id) }}">
                                                        @lang('messages.edit')<i class="la la-edit options-style"></i>
                                                    </a>

                                                @endcan

                                                @can('delete_products', $value)

                                                    <a class="dropdown-item delete_data" data="{{ $value->id }}" data_name="{{$value->title['ar'] }}" >
                                                        @lang('messages.delete')<i class="la la-trash options-style"></i>
                                                    </a>

                                                @endcan
                                            </div>
                                        </div>


                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>

@endsection
@section('scripts')
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
