@extends('admin.layouts.master')

@section('title')
    طلبات {{$title}}
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <!-- Sweet Alert-->
    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
@endsection


@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.orders.index', ['order', $order->status]) }}">طلبات {{$title}}</a></li>
                        <li class="breadcrumb-item active">طلبات {{$title}}</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع طلبات العضو {{$user->name}}</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">

                <h4 class="mb-2"> {{ $user->name }} </h4>


                <div class="text-left mt-3">


                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.name') :</strong> <span class="ml-2">{{$user->name}}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>رقم الطلب :</strong> <span class="ml-2 ">{{ $order->id }}</span></p>
                    <p class=" mb-2 font-13"><strong>حالة الطلب :</strong>  <span class="ml-2 badge badge-pill badge-secondary">
                        {{ getOrderType($order->status) }}
                    </span></p>
                    <p class=" mb-2 font-13"><strong>طريقة الدفع :</strong>  <span class="ml-2">
                      {{\App\Models\PaymentMethod::find($order->payment_method)->name['ar']}}
                    </span></p>
                    @if($order->transaction_id)
                    <p class=" mb-2 font-13"><strong>رقم العملية :</strong>  <span class="ml-2">
                      {{ $order->transaction_id }}
                    </span></p>
                    @endif

                    <p class=" mb-2 font-13"><strong>قيمة الطلب :</strong>  <span class="ml-2">
                      {{ $order->products_total }}   ريال
                    </span></p>
                    <p class=" mb-2 font-13"><strong>قيمة الشحن :</strong>  <span class="ml-2">
                      {{ $order->shipping_cost }}   ريال
                    </span></p>
                    <p class=" mb-2 font-13"><strong>قيمة الخصم :</strong>  <span class="ml-2">
                      {{ $order->total_after_coupon }}   ريال
                    </span></p>

                    <p class=" mb-2 font-13"><strong>الاجمالي :</strong>  <span class="ml-2">
                      {{ $order->all_total }}
                    </span></p>
                    <p class="text-muted mb-2 font-13"><strong>تاريخ الطلب :</strong> <span class="ml-2 badge badge-info ">{{ $order->created_at->format('Y-m-d g:i A') }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>اسم المستلم :</strong> <span class="ml-2 badge badge-warning ">{{ $order->name ? $order->name : '---' }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>رقم الجوال :</strong> <span class="ml-2 badge badge-warning ">{{ $order->phone ? $order->phone : '---' }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>المدينة :</strong> <span class="ml-2 badge badge-warning ">{{ $order->city->name['ar'] }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>المنطقة :</strong> <span class="ml-2 badge badge-warning ">{{  $order->region->name['ar']  }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>ملاحظات :</strong> <span class="ml-2 badge badge-warning ">{{ $order->notes ? $order->notes : '---' }}</span></p>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->


    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">طلبات {{$title}}</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th scope="col">@lang('web.image')</th>
                            <th scope="col">@lang('web.Product_name')</th>
                            <th scope="col">@lang('web.price')</th>


                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $product )
                                <?php ++$i; ?>
                                <tr>
                                    <?php $value = \App\Models\Product::withTrashed()->find($product->product_id); ?>
                                    <td> {{ $i }} </td>
                                    <th>
                                        <div class="table-img">
                                            <img src="{{asset('uploads/products/'.$value->images()->first()->image)}}" class="rounded mr-1" height="60" class="rounded-circle avatar-lg img-thumbnail">
                                        </div>
                                    </th>
                                    <td><a href="{{ route('admin.products.show', $value->id) }}">
                                            @if($value->type == "gift")
                                                {{ $value->title }}
                                            @else
                                                {{$value->title[app()->getLocale()]}}
                                            @endif
                                        </a></td>

                                    <td>{{$product->price}} ريال </td>





                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>

    <script>

        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}"},
                { extend: 'excel', text: "{{trans('messages.excel')}}" },
                { extend: 'print', text: "{{trans('messages.print')}}"},
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );


    </script>
@endsection
