<div class="tab-pane show active" id="general">
<ul class="nav nav-tabs nav-bordered">
        @foreach(siteLanguages() as $key => $language)
            <li class="nav-item">
                <a href="#tab_{{ $key }}" data-toggle="tab" aria-expanded="false" class="nav-link {{ $key == 'ar' ? 'active' : '' }}"> {{ $language }} </a>
            </li>
        @endforeach

    </ul>
    <div class="tab-content">
        @foreach(siteLanguages() as $key => $language)
            <div class="tab-pane {{ $key == 'ar' ? 'active' : '' }}" id="tab_{{ $key }}">
                    <div class="form-group row mb-3">
                        <label for="name[{{ $key }}]" class="col-md-3 col-form-label">@lang('messages.name'):
                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-9">
                            {!! Form::text('name['.$key.']', isset($paymentMethod) ? $paymentMethod->name[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> 'name['.$key.']', 'placeholder'=> $language,  'maxlength'=> "100"]) !!}
                        </div>
                    </div>


            </div>

        @endforeach


    </div>
</div>

<div class="tab-pane" id="another">
    <div class="form-group row mb-3">
        <label for="type" class="col-md-3 col-form-label">طريقة الدفع :
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="selectpicker" data-live-search="true"  data-style="btn-light" id="type" name="type" parsley-trigger="change" required >
                <option value>طريقة الدفع</option>
                <option value="visa"  {{ isset($paymentMethod) ? ($paymentMethod->type == "visa" ? "selected" : '') : (old("type") == "visa" ? "selected" : "")  }}>دفع الكتروني</option>
                <option value="cash" {{ isset($paymentMethod) ? ($paymentMethod->type == "cash" ? "selected" : '') : (old("type") == "cash" ? "selected" : "")  }} >كاش</option>

            </select>
        </div>
    </div>


    <div class="form-group row mb-3" id="icon" >
        <label class="col-md-3 col-form-label">الايقونة في حالة نوع الدفع الالكتروني:
            <span class="text-danger">*</span>
        </label>
        <div class="col-9">
            <div class="fileinput fileinput-new" data-provides="fileinput">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                    @if( isset($paymentMethod->icon) )
                        <img src="{{ URL::asset('uploads/paymentMethods/'.$paymentMethod->icon) }}">
                    @endif
                </div>
                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo" accept="image/*" {{isset($paymentMethod->type)  && $paymentMethod->icon == null ?  ' parsley-trigger="change" required' : '' }}>
                        </span>
                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                </div>
            </div>
        </div>
    </div>
    <div class="form-group row mb-3" id="method" @if(isset($paymentMethod) && $paymentMethod->type =="visa")
    @else style="display: none;" @endif>
        <label for="method" class="col-md-3 col-form-label">نوع الدفع :
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="selectpicker" data-live-search="true"  data-style="btn-light" name="method"  >
                <option value>نوع الدفع</option>
                <option value="src_card"  {{ isset($paymentMethod) ? ($paymentMethod->method == "src_card" ? "selected" : '') : (old("method") == "src_card" ? "selected" : "" ) }}>فيزا/ ماستر كارد</option>
                <option value="src_sa.mada" {{ isset($paymentMethod) ? ($paymentMethod->method == "src_sa.mada" ? "selected" : '') : (old("method") == "src_sa.mada" ? "selected" : "" ) }} >مدى</option>

            </select>
        </div>
    </div>
    <div class="form-group row mb-3" id="currency" @if(isset($paymentMethod) && $paymentMethod->type =="visa")
    @else style="display: none;" @endif>
        <label for="currency" class="col-md-3 col-form-label">العملة الافتراضية :
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="selectpicker" data-live-search="true"  data-style="btn-light"  name="currency"   >
                <option value>العملة الافتراضية</option>
                <option value="SAR"  {{ isset($paymentMethod) ? ($paymentMethod->currency == "SAR" ? "selected" : '') : (old("currency") == "SAR" ? "selected" : "")  }}>الريال السعودي</option>
                <option value="EGP" {{ isset($paymentMethod) ?( $paymentMethod->currency == "EGP" ? "selected" : '') : (old("currency") == "EGP" ? "selected" : "")  }} >الجنية المصري</option>
                <option value="USD" {{ isset($paymentMethod) ?( $paymentMethod->currency == "USD" ? "selected" : '') : (old("currency") == "USD" ? "selected" : "")  }} >الدولار</option>

            </select>
        </div>
    </div>
</div>

