@extends('admin.layouts.master')

@section('title')
    @lang('messages.View_admin_powers')
@endsection

@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.roles.index') }}">@lang('messages.Supervisory_groups')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.View_admin_powers')</li>
                    </ol>
                </div>
                <h4 class="page-title">{{ $role->name}}</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h3 class="mb-3 header-title">@lang('messages.View_admin_powers') <small style="color: #36c6d3;">{{ $role->name }}</small> </h3>

                    {!! Form::model($role, ['method' => 'PATCH', 'url' => route('admin.roles.update', $role->id),'class' => 'form-horizontal']) !!}
                    <input type="hidden" name="name" value="{{ $role->name }}">
                    <div class="col-lg-12">
                        @foreach( $data as $value )
                            @foreach( $value as $key => $permissions )
                        <h4 class="header-title col-md-12 mt-5 mt-sm-0">{{ trans("admin.$key") }}</h4>


                        <div class="checkbox checkbox-info  mb-2 mt-3 form-row" style="margin-right: 46px;">
                            @foreach( $permissions as $permission )
                            <div class="custom-control custom-checkbox form-group col-lg-5">
                                <input type="checkbox" class="custom-control-input"   name="permissions[]" value="{{ $permission->id }}" id="{{ $permission->id }}"  {{ checkPermissionExists($permission->id, $rolePermissions) ? "checked" : " " }}>
                                <label class="custom-control-label" for="{{ $permission->id }}">{{ trans("admin.".explodeByUnderscore($permission->name)[0]) }} {{ trans("admin.$key") }}</label>
                            </div>
                            @endforeach
                        </div>

                            @endforeach
                        @endforeach
                    </div>
                    @if( $role->id != 1)
                        <div class="form-group mb-0 justify-content-end row">
                            <button type="submit" class="btn btn-info waves-effect waves-light"  onclick="this.disabled=true;this.value='تم الارسال, انتظر...';this.form.submit();">  @lang('messages.save') </button>
                        </div>

                    @endif

                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
@endsection
