@extends('admin.layouts.master')

@section('title')
    تعديل المنتجات
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/jquery-nice-select/nice-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
    <style>
        .select2-container .select2-selection--multiple .select2-selection__rendered {
            width: 544px;
        }
        .close{
            float: right !important;
            right: 22px !important;
            position: relative !important;
            opacity: 1 !important;
        }
        .header-title{
            font-size: large;
            font-weight: bold;
        }
    </style>
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.products.index') }}">المنتجات</a></li>
                        <li class="breadcrumb-item active">تعديل المنتجات</li>
                    </ol>
                </div>
                <h4 class="page-title">تعديل المنتجات</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($product, ['method' => 'PATCH', 'url' => route('admin.products.update', $product->id),'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">معلومات المنتجات</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>


                <ul class="nav nav-tabs nav-bordered">
                    <li class="nav-item">
                        <a href="#general" data-toggle="tab" aria-expanded="false" class="nav-link active">
                            @lang('messages.general')
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#another" data-toggle="tab" aria-expanded="true" class="nav-link">
                            @lang('messages.another')
                        </a>
                    </li>

                </ul>
                <div class="card-box">
                    <div class="tab-content">
                        @include('admin.products._form')


                    </div>
                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/jquery-nice-select/jquery.nice-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-maxlength/bootstrap-maxlength.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-advanced.init.js') }}"></script>
    <script type="text/javascript" src="//code.jquery.com/ui/1.12.1/jquery-ui.js" ></script>

    <script type="text/javascript" src="//cdn.datatables.net/v/dt/dt-1.10.12/datatables.min.js"></script>

    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jquery-tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/summernote-custom.js') }}"></script>

    <script>
        $(document).ready(function () {
            var yourArray=[];
            $('select[name="category_id"]').on('change', function() {
                var id = $(this).val();

                if(id == ''){
                    $('#subCategory').empty();


                }else{
                    $.ajax({
                        url: '/get/subCategories/'+id,
                        type: "GET",
                        dataType: "json",
                        success:function(data) {

                            if(data['categories'].length > 0){
                                $('#subCategory').empty();
                                $('#show_attributes').empty();


                                $('#subCategory').append('<div class="form-group row mb-3"> <label for="attribute" class="col-md-3 col-form-label">الاقسام الفرعية <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id" name="sub_category_id"  parsley-trigger="change" required >');
                                $('select[name="sub_category_id"]').append('<option value> اختر</option>');
                                $.each(data['categories'], function(index , categories) {

                                    $('select[name="sub_category_id"]').append('<option value="'+ categories.id +'">'+ categories.name +'</option>');

                                });
                                $('#subCategory').append(' </select></div></div>');
                                $('.selectpicker').selectpicker('refresh');

                            }else{
                                $('#subCategory').empty();

                            }


                        }
                    });
                }



            });
            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.delete_data', function() {

                var id = $(this).attr('data');
                var swal_text = ' الصورة ' + $(this).attr('data_name');
                var swal_title = '{{trans('messages.Are_you_sure_to_delete?')}}';

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/products/destroy-image" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id , 'product_id' : "{{$product->id}}" },
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){
                                    Swal.fire({
                                        type: 'success',
                                        title: "{{trans('messages.Deletion_successful')}}",
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: "{{trans('messages.confirm')}}",
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });

        });



    </script>
@endsection
