@extends('admin.layouts.master')

@section('title')
    المنتجات
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.products.index') }}">المنتجات</a></li>
                        <li class="breadcrumb-item active">المنتجات</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع المنتجات</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">المنتجات</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th> الاسم </th>
                            <th> اسم التاجر </th>
                            <th>القسم الرئيسي</th>
                            <th> الخصم % </th>
                            <th> التمييز </th>
                            <th> حالة المنتج </th>
                            <th> عدد المبيعات </th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td class="no_dec">
                                        <a class="dropdown-item" href="{{ route('admin.products.show', $value->id) }}">
                                            {{$value->title['ar'] }}
                                        </a>
                                    </td>
                                    <td class="no_dec">
                                        <a class="dropdown-item" href="{{ route('admin.dealers.show', $value->user_id) }}">
                                            {{$value->user->name }}
                                        </a>
                                    </td>
                                    <td class="no_dec">
                                        {{$value->category->name['ar']}}
                                    </td>
                                    <td class="no_dec">
                                        {{ $value->discount ? $value->discount : '--' }}
                                    </td>
                                    <td>
                                        <span class="badge  badge-pill {{ $value->special == "1" ? "badge-secondary" : "badge-light-secondary" }}"> {{ $value->special == "1" ? trans('messages.special') : trans('messages.not_special') }} </span>
                                    </td>
                                    <td class="no_dec">
                                        @can('activate_products', $value)
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" value="{{$value->active ? 0 : 1}}"  data_str="{{ $value->active ? "تم تعطيل المنتج" : "تم تفعيل المنتج"}}" @if($value->active == 1) checked @endif onclick="enableProduct({{$value->id}})" id="customSwitch1{{$value->id}}">
                                                <label class="custom-control-label" for="customSwitch1{{$value->id}}">مفعل/معطل</label>
                                            </div>
                                        @else
                                            <span class="badge badge-light-danger">
                                                 <i class=" la la-close"></i> @lang('messages.You_do_not_have_permission')
                                             </span>
                                        @endif
                                    </td>
                                    <td>{{$value->sold}}</td>
                                    <td>
                                        <div class="btn-group mb-2">
                                            <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations') </button>
                                            <div class="dropdown-menu">

                                                @can('show_products', $value)

                                                    <a class="dropdown-item" href="{{ route('admin.products.show', $value->id) }}">
                                                        @lang('messages.view')<i class="la la-eye options-style"></i>
                                                    </a>

                                                @endcan
                                                    <a class="dropdown-item change_status" data="{{ $value->id }}" data_name="{{ $value->title['ar']  }}" data_str="{{ $value->special == "1" ? trans('messages.not_specialize') : trans('messages.specialize') }}" data_status="{{ $value->special == "1" ? 0 : 1 }}">
                                                        {{ $value->special == "1" ? trans('messages.not_specialize') : trans('messages.specialize') }} <i class="la la-{{ $value->special == "1" ? 'close' : 'check' }} options-style"></i>
                                                    </a>

                                                @can('edit_products', $value)

                                                    <a class="dropdown-item" href="{{ route('admin.products.edit', $value->id) }}">
                                                        @lang('messages.edit')<i class="la la-edit options-style"></i>
                                                    </a>

                                                @endcan

                                                @can('delete_products', $value)

                                                    <a class="dropdown-item delete_data" data="{{ $value->id }}" data_name="{{$value->title['ar'] }}" >
                                                        @lang('messages.delete')<i class="la la-trash options-style"></i>
                                                    </a>

                                                @endcan
                                            </div>
                                        </div>


                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')

    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>
    <script>
        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );
        function enableProduct(id){
            var data_str ='';
            if(document.getElementById('customSwitch1'+id).value == 0){
                data_str = "تم تعطيل المنتج "
            }else{
                data_str = "تم تفعيل المنتج "
            }

            $.ajax({
                url: "{{ url('/') }}" + "/admin/products/activate-product/"+id ,
                type: "GET",
                data:{'active' : document.getElementById('customSwitch1'+id).value},
                dataType: "json",
                success:function(data) {
                    // console.log(data);
                    Swal.fire({
                        type: 'success',
                        title: data_str,
                        confirmButtonClass: 'btn-success',
                        confirmButtonText: "{{trans('messages.confirm')}}",
                    }).then((result) => {
                        location.reload();
                    });


                }
            });



        }
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.delete_data', function() {

                var id = $(this).attr('data');
                var swal_text = ' المنتج ' + $(this).attr('data_name');
                var swal_title = '{{trans('messages.Are_you_sure_to_delete?')}}';

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/products/destroy" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id},
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){
                                    Swal.fire({
                                        type: 'success',
                                        title: "{{trans('messages.Deletion_successful')}}",
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: "{{trans('messages.confirm')}}",
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });

            $('body').on('click', '.change_status', function() {

                var id = $(this).attr('data');
                var data_str = $(this).attr('data_str');
                var swal_text = '"' + $(this).attr('data_name') + '"';
                var swal_title = '{{trans('messages.Are_you_sure_of')}} '+ data_str +' المنتج ؟';
                var status = $(this).attr('data_status');

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/products/change-special" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id, 'special': status, 'data_str': data_str},
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){
                                    Swal.fire({
                                        type: 'success',
                                        title:  data_str +' المنتج',
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: '{{trans('messages.confirm')}}',
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });
        });

    </script>

@endsection
