@extends('admin.layouts.master')

@section('title')
    عرض تفاصيل المنتجات
@endsection



@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.products.index') }}"> المنتجات</a></li>
                        <li class="breadcrumb-item active">عرض جميع المنتجات</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض تفاصيل المنتجات</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">

                <h4 class="mb-2">
                    @if($product->type == "gift")
                        {{ $product->title }}
                    @else
                        {{$product->title[app()->getLocale()]}}
                    @endif
                </h4>


                <div class="text-left mt-3">
                    <p class="text-muted mb-2 font-13"><strong>اسم التاجر :</strong> <span class="ml-2"> {{ $product->user->name }}</span></p>

                    @if($product->type == "product")
                    <p class="text-muted mb-2 font-13"><strong>القسم الرئيسي :</strong> <span class="ml-2">  {{$product->type == "product" ? $product->category->name['ar'] : '--'}}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>القسم الفرعي :</strong> <span class="ml-2">    {{\App\Models\Category::find($product->sub_category_id)? \App\Models\Category::find($product->sub_category_id)->name['ar'] : '--'}}</span></p>
                    @endif
                     <p class="text-muted mb-2 font-13"><strong>الخصم (%) :</strong> <span class="ml-2"> {{ $product->discount ? $product->discount : '--' }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>السعر :</strong> <span class="ml-2"> {{ $product->price ? $product->price : '--' }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>مميز :</strong> <span class="ml-2"> {{ $product->special ? "مميز" : 'غير مميز' }}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>تفاصيل المنتج :</strong> <span class="ml-2">   @if($product->type == "product") {!!  $product->description['ar']  !!} @else {{ $product->description }} @endif</span></p>


                    <p class="mb-2 font-13"><strong>الصور :</strong></p>
                        <ul class="text-muted mb-2 font-13">
                            @if(count($product->images()->get()) > 0)
                                @foreach($product->images()->get() as $value)
                                    <li>
                                        <a href="{{asset('uploads/products/'.$value->image)}}" target="_blank" >
                                            <img src="{{asset('uploads/products/'.$value->image)}}" class="rounded mr-1" height="60" class="rounded-circle avatar-lg img-thumbnail"
                                            >
                                        </a>
                                    </li>
                                    <br>
                                @endforeach
                            @endif
                        </ul>

                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->


    </div>

@endsection
@section('scripts')
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
