@extends('admin.layouts.master')

@section('title')
    طلبات السحب
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />

    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.pulls.index') }}">طلبات السحب</a></li>
                        <li class="breadcrumb-item active"> طلبات السحب </li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع طلبات السحب </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">طلبات السحب </h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>

                            <th> رقم الطلب </th>
                            <th> اسم البنك </th>
                            <th>اسم التاجر </th>
                            <th>رقم الايبان </th>
                            <th>رقم الجوال </th>
                            <th>المبلغ المراد سحبه </th>
                            <th>الحالة </th>
                            <th>تاريخ الطلب </th>
                            <th>العمليات </th>

                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td> {{ $value->id }} </td>

                                    <td class="no_dec">
                                        {{ $value->bank_name }}

                                    </td>

                                    <td class="no_dec">
                                        <a href="{{ route('admin.dealers.show', $value->user_id) }}">  {{ $value->name }} </a>

                                    </td>
                                    <td>
                                        {{ $value->iban }}
                                    </td>
                                    <td>
                                        {{ $value->phone }}
                                    </td>
                                    <td>
                                        {{ $value->balance }}
                                    </td>
                                    <td>
                                        @if($value->status == "approved")
                                            <span class="badge badge-light-success" > تم  التحويل</span>
                                        @elseif($value->status == "waiting")
                                            <span class="badge badge-warning" > في انتظار التحويل</span>
                                        @elseif($value->status == "refused")
                                            <span class="badge badge-danger" > تم رفض التحويل</span>
                                        @endif

                                    </td>
                                    <td> {{ $value->created_at->format('Y-m-d g:i A') }} </td>

                                    <td>
                                        @if($value->status == "waiting")
                                        <div class="btn-group mb-2">
                                            <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations') </button>
                                            <div class="dropdown-menu">


                                                @can('activate_user_wallets', $value)


                                                    <a class="dropdown-item confirm_data" data="{{ $value->id }}" data_name="{{$value->name }}" >
                                                        تأكيد التحويل<i class="la la-check options-style"></i>
                                                    </a>


                                                @endcan
                                            </div>
                                        </div>
                                        @else
                                            تم تأكيد التحويل
                                        @endif


                                    </td>


                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>

                </div> <!-- end card body-->

            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')

    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>

    <script>
        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4 ]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.confirm_data', function() {

                var id = $(this).attr('data');
                var swal_text = ' التحويلات البنكية   ' + $(this).attr('data_name');
                var swal_title = 'هل انت متأكد من تأكيد التحويل البنكي';

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/pulls/confirm-transfer" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id},
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){

                                    Swal.fire({
                                        type: 'success',
                                        title: "تم تأكيد التحويل بنجاح",
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: "{{trans('messages.confirm')}}",
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });


        });

    </script>
@endsection
