@extends('admin.layouts.master')

@section('title')
    تأكيد التحويل البنكي
@endsection
@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/jquery-nice-select/nice-select.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/select2/select2.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />

@endsection
@section('page_header')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.pulls.index') }}">الاعضاء</a></li>
                        <li class="breadcrumb-item active"> تأكيد التحويل البنكي</li>
                    </ol>
                </div>
                <h4 class="page-title">  تأكيد التحويل البنكي <span> <a href="{{ route('admin.users.show', $user->id) }}"> {{ $user->name }} </a> </span>
                </h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-9">
            <div class="card">
                <div class="card-body">


                    {!! Form::open([ 'url' => route('admin.pulls.confirm-transfer', $pull->id), 'class' => 'form-horizontal' , 'files'=> 'true']) !!}

                    <div class="form-group row mb-3">
                        <label class="col-md-3 col-form-label">الصورة:
                            <span class="text-danger">*</span>
                        </label>
                        <div class="col-9">
                            <div class="fileinput fileinput-new" data-provides="fileinput">
                                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                                    @if( isset($pull->image) )
                                        <img src="{{ URL::asset('uploads/pulls/'.$pull->image) }}">
                                    @endif
                                </div>
                                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo" accept="image/*" {{isset($pull->image) ? '' : ' parsley-trigger="change" required' }}>
                        </span>
                                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-0 justify-content-end row">
                        <button type="submit" class="btn btn-info waves-effect waves-light"  onclick="this.disabled=true;this.value='تم الارسال, انتظر...';this.form.submit();">  تأكيد التحويل</button>
                    </div>


                    {!! Form::close() !!}

                </div>  <!-- end card-body -->
            </div>  <!-- end card -->
        </div>  <!-- end col -->
    </div>
    <!-- end row-->

@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
@endsection
