@extends('admin.layouts.master')

@section('title')
    @lang('messages.settings')
@endsection

@section('styles')
    <link rel="stylesheet" href="{{ URL::asset('admin/css/bootstrap-fileinput.css') }}">
    <link href="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.css') }}" rel="stylesheet" type="text/css" />
@endsection
@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.settings.index') }}">@lang('messages.settings')</a></li>
                        <li class="breadcrumb-item active">@lang('messages.settings')</li>
                    </ol>
                </div>
                <h4 class="page-title">@lang('messages.settings')</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')


    <div class="row">
        <div class="col-9">
            {!! Form::model($setting, ['method' => 'PATCH', 'url' => route('admin.settings.update-products', $setting->id),'class' => 'form-horizontal form-row-seperated parsley-examples', 'files'=> 'true']) !!}
            <div class="card-box">
                <h4 class="header-title mb-4">@lang('messages.information') @lang('messages.settings')</h4>
                <div class="actions btn-set btn-position" >
                    <button class="btn btn-success" type="submit" >
                        @lang('messages.save')
                    </button>
                </div>



                <div class="card-box">

                        <h4 class="header-title mb-4">الاعلان الاول عن منتج</h4>
                        {{--    <div class="form-group row mb-3">--}}
                        {{--        <label for="first_product_title_ad" class="col-md-3 col-form-label">العنوان :--}}
                        {{--            <span class="text-danger">*</span>--}}
                        {{--        </label>--}}
                        {{--        <div class="col-9">--}}

                        {{--            {!! Form::text('first_product_title_ad[ar]', isset($setting->first_product_title_ad) ? unserialize($setting->first_product_title_ad)['ar'] : null, ['class'=> 'form-control', 'id'=> 'first_product_title_ad', 'placeholder' => 'عربي']) !!}--}}

                        {{--        </div>--}}
                        {{--    </div>--}}
                        {{--    <div class="form-group row mb-3">--}}
                        {{--        <label for="first_product_title_ad" class="col-md-3 col-form-label">العنوان :--}}
                        {{--            <span class="text-danger">*</span>--}}
                        {{--        </label>--}}
                        {{--        <div class="col-9">--}}

                        {{--            {!! Form::text('first_product_title_ad[en]', isset($setting->first_product_title_ad) ? unserialize($setting->first_product_title_ad)['en'] : null, ['class'=> 'form-control', 'id'=> 'first_product_title_ad', 'placeholder' => 'English']) !!}--}}

                        {{--        </div>--}}
                        {{--    </div>--}}

                        {{--    <div class="form-group row mb-3">--}}
                        {{--        <label for="first_product_details_ad" class="col-md-3 col-form-label">التفاصيل :--}}
                        {{--            <span class="text-danger">*</span>--}}
                        {{--        </label>--}}
                        {{--        <div class="col-9">--}}

                        {{--            {!! Form::text('first_product_details_ad[ar]', isset($setting->first_product_details_ad) ? unserialize($setting->first_product_details_ad)['ar'] : null, ['class'=> 'form-control', 'id'=> 'first_product_details_ad', 'placeholder' => 'عربي']) !!}--}}

                        {{--        </div>--}}
                        {{--    </div>--}}
                        {{--    <div class="form-group row mb-3">--}}
                        {{--        <label for="first_product_details_ad" class="col-md-3 col-form-label">التفاصيل :--}}
                        {{--            <span class="text-danger">*</span>--}}
                        {{--        </label>--}}
                        {{--        <div class="col-9">--}}

                        {{--            {!! Form::text('first_product_details_ad[en]', isset($setting->first_product_details_ad) ? unserialize($setting->first_product_details_ad)['en'] : null, ['class'=> 'form-control', 'id'=> 'first_product_details_ad', 'placeholder' => 'English']) !!}--}}

                        {{--        </div>--}}
                        {{--    </div>--}}
                        <div class="form-group row mb-3">
                            <label class="col-md-3 col-form-label">الصورة:
                                <p class="text-danger">المقاس المفضل (376*262)</p>
                            </label>
                            <div class="col-9">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                                        @if( isset($setting->first_product_image_ad) )
                                            <img src="{{ URL::asset('uploads/settings/'.$setting->first_product_image_ad) }}">
                                        @endif
                                    </div>
                                    <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="third_photo" accept="image/*" >
                        </span>
                                        <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-md-3 col-form-label">الصورة (انجيلزي):
                                <p class="text-danger">المقاس المفضل (376*262)</p>
                            </label>
                            <div class="col-9">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                                        @if( isset($setting->first_product_image_ad_en) )
                                            <img src="{{ URL::asset('uploads/settings/'.$setting->first_product_image_ad_en) }}">
                                        @endif
                                    </div>
                                    <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="third_photo_en" accept="image/*" >
                        </span>
                                        <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label for="first_product_id_ad" class="col-md-3 col-form-label">المنتجات
                                {{--            <span class="text-danger">*</span>--}}
                            </label>

                            <div class="col-9">
                                <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="first_product_id_ad" name="first_product_id_ad"  >
                                    <option value>المنتجات</option>
                                    @foreach($products as $data)

                                        <option value="{{$data->id}}" {{ isset($setting) ? $data->id == $setting->first_product_id_ad ? "selected" : '' : old("first_product_id_ad") == $data->id  ? "selected" : ""  }}>{{$data->name['ar']}}</option>

                                    @endforeach

                                </select>
                            </div>
                        </div>
                        <hr>
                        <h4 class="header-title mb-4">الاعلان الثاني عن منتج</h4>

                        <div class="form-group row mb-3">
                            <label class="col-md-3 col-form-label">الصورة:
                                <p class="text-danger">المقاس المفضل (184*1170)</p>
                            </label>
                            <div class="col-9">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                                        @if( isset($setting->second_product_image_ad) )
                                            <img src="{{ URL::asset('uploads/settings/'.$setting->second_product_image_ad) }}">
                                        @endif
                                    </div>
                                    <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="forth_photo" accept="image/*" >
                        </span>
                                        <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-md-3 col-form-label">الصورة (انجيلزي):
                                <p class="text-danger">المقاس المفضل (184*1170)</p>
                            </label>
                            <div class="col-9">
                                <div class="fileinput fileinput-new" data-provides="fileinput">
                                    <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                                        @if( isset($setting->second_product_image_ad_en) )
                                            <img src="{{ URL::asset('uploads/settings/'.$setting->second_product_image_ad_en) }}">
                                        @endif
                                    </div>
                                    <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="forth_photo_en" accept="image/*" >
                        </span>
                                        <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label for="second_product_id_ad" class="col-md-3 col-form-label">المنتجات
                                {{--            <span class="text-danger">*</span>--}}
                            </label>

                            <div class="col-9">
                                <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="second_product_id_ad" name="second_product_id_ad"  >
                                    <option value>المنتجات</option>
                                    @foreach($products as $data)

                                        <option value="{{$data->id}}" {{ isset($setting) ? $data->id == $setting->second_product_id_ad ? "selected" : '' : old("second_product_id_ad") == $data->id  ? "selected" : ""  }}>{{$data->name['ar']}}</option>

                                    @endforeach

                                </select>
                            </div>
                        </div>







                </div>
            </div> <!-- end card-box-->
            {!! Form::close() !!}
        </div> <!-- end col -->


    </div>
    <!-- end row -->


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/select2/select2.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-select/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/bootstrap-fileinput.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/parsleyjs/parsley.min.js') }}"></script>
    <script src="{{ URL::asset('admin/js/pages/form-validation.init.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/moment/moment.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/bootstrap-colorpicker/bootstrap-colorpicker.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/clockpicker/bootstrap-clockpicker.min.js') }}"></script>
    <!-- Init js-->
    <script src="{{ URL::asset('admin/js/pages/form-pickers.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jquery-tiny-custom.js') }}"></script>
    <script src="{{ URL::asset('admin/js/summernote-custom.js') }}"></script>
    <script>
        $(document).ready(function() {
            $( "body" ).on( "change", "select[name='first_category_id']", function() {
                var id = $(this).val();

                $.ajax({
                    url: '/get/subCategories/'+id,
                    type: "GET",
                    dataType: "json",
                    success:function(data) {

                        $('#sub_category_1').empty();
                        if (data['categories'].length > 0) {
                            $('#sub_category_1').append('<div class="form-group row mb-3"> <label for="sub_category_id_1" class="col-md-3 col-form-label">القسم الفرعي <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id_1" name="sub_category_id_1" parsley-trigger="change" required >');

                            $('select[name="sub_category_id_1"]').append('<option value>القسم الفرعي</option>');

                            $.each(data['categories'], function (index, categories) {

                                $('select[name="sub_category_id_1"]').append('<option value="' + categories.id + '">' + categories.name + '</option>');

                            });
                            $('#sub_category_1').append(' </select></div></div>');
                            $('.selectpicker').selectpicker('refresh');
                        }
                    }
                });

            });
            $( "body" ).on( "change", "select[name='second_category_id']", function() {
                var id = $(this).val();

                $.ajax({
                    url: '/get/subCategories/'+id,
                    type: "GET",
                    dataType: "json",
                    success:function(data) {

                        $('#sub_category_2').empty();
                        if (data['categories'].length > 0) {
                            $('#sub_category_2').append('<div class="form-group row mb-3"> <label for="sub_category_id_2" class="col-md-3 col-form-label">القسم الفرعي <span class="text-danger">*</span> </label><div class="col-9"><select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="sub_category_id_2" name="sub_category_id_2" parsley-trigger="change" required >');

                            $('select[name="sub_category_id_1"]').append('<option value>القسم الفرعي</option>');

                            $.each(data['categories'], function (index, categories) {

                                $('select[name="sub_category_id_2"]').append('<option value="' + categories.id + '">' + categories.name + '</option>');

                            });
                            $('#sub_category_2').append(' </select></div></div>');
                            $('.selectpicker').selectpicker('refresh');
                        }
                    }
                });

            });
        });
    </script>
@endsection
