<div class="tab-pane show active" id="general">
    <ul class="nav nav-tabs nav-bordered">
        @foreach(siteLanguages() as $key => $language)
            <li class="nav-item">
                <a href="#tab_{{ $key }}" data-toggle="tab" aria-expanded="false" class="nav-link {{ $key == 'ar' ? 'active' : '' }}"> {{ $language }} </a>
            </li>
        @endforeach

    </ul>
    <div class="tab-content">
        @foreach(siteLanguages() as $key => $language)
            <div class="tab-pane {{ $key == 'ar' ? 'active' : '' }}" id="tab_{{ $key }}">
                <div class="form-group row mb-3">
                    <label for="username[{{ $key }}]" class="col-md-3 col-form-label">اسم :
                        <span class="text-danger">*</span>
                    </label>
                    <div class="col-9">
                        {!! Form::text("name_$key", isset($subCategory) ? $subCategory->name[$key] : null, ["parsley-trigger"=>"change", "required" ,'class'=> 'form-control', 'id'=> "name_$key", 'placeholder'=> $language,  'maxlength'=> "100"]) !!}
                    </div>
                </div>


            </div>

        @endforeach


    </div>
</div>


<div class="tab-pane" id="another">

    <div class="form-group row mb-3">
        <label for="user_id" class="col-md-3 col-form-label">القسم الرئيسي
            <span class="text-danger">*</span>
        </label>

        <div class="col-9">
            <select class="form-control selectpicker" data-live-search="true"  data-style="btn-light" id="category_id" name="category_id"  parsley-trigger="change" required >
                <option value>اختر القسم الرئيسي</option>
                @foreach( $categories as $data)
                    <option value="{{ $data->id }}" {{ old("category_id") ? ( $data->id == $subCategory->parent_id ? "selected" : "") : '' }} {{ isset($subCategory)? $data->id == $subCategory->parent_id  ? 'selected' : '' :''}}>{{ $data->name[App::getLocale()] }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="form-group row mb-3">
        <label class="col-md-3 col-form-label">@lang('messages.image'):
            <span class="text-danger">*</span>
        </label>
        <div class="col-9">
            <div class="fileinput fileinput-new" data-provides="fileinput">
                <div class="fileinput-preview thumbnail" data-trigger="fileinput" style="width: 330px; height: 150px;">
                    @if( isset($subCategory->image) )
                        <img src="{{ URL::asset('uploads/categories/'.$subCategory->image) }}">
                    @endif
                </div>
                <div>
                        <span  class="btn btn-outline-danger waves-effect waves-light btn-file">
                            <span class="fileinput-new"> @lang('messages.change') @lang('messages.image') </span>
                            <span class="fileinput-exists"> @lang('messages.change') </span>
                            <input type="file" name="photo" accept="image/*" {{isset($subCategory->image) ? '' : ' parsley-trigger="change" required' }}>
                        </span>
                    <a href="javascript:;" class="btn btn-outline-danger waves-effect waves-light fileinput-exists" data-dismiss="fileinput"> @lang('messages.delete') </a>
                </div>
            </div>
        </div>
    </div>

</div>













