@extends('admin.layouts.master')

@section('title')
    الأعضاء
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <!-- Sweet Alert-->
    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
@endsection

@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">الأعضاء</a></li>
                        <li class="breadcrumb-item active">الأعضاء</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع الأعضاء</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">الأعضاء</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th> @lang('messages.name') </th>
                            <th> @lang('messages.email') </th>
                            <th> @lang('messages.phone')</th>
                            <th> الطلبات</th>
                            <th> عدد طلبات العضو</th>
                            <th> حالة العضوية </th>
                            <th> @lang('messages.Date_added') </th>
                            <th> @lang('messages.operations') </th>
                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $value )
                                <?php ++$i; ?>
                                <tr>

                                    <td> {{ $i }} </td>
                                    <td class="no_dec"><a href="{{ route('admin.users.show', $value->id) }}"> {{ $value->name }} </a></td>
                                    <td class="phone-text"><a href="mailto:{{ $value->email }}"> {{ $value->email }} </a></td>
                                    <td class="phone-text"><a href="del:{{ $value->phone }}"> {{ $value->phone }}</a></td>

                                    <td>
                                        @can('view_orders', \App\Models\Order::class)
                                            <a href="{{ route('admin.users.user-orders', $value->id) }}" class="btn btn-outline-info waves-effect waves-light">
                                                <i class="la la-eye"></i> @lang('messages.view')
                                            </a>
                                        @else
                                            <span class="badge badge-light-danger">
                                                 <i class=" la la-close"></i> @lang('messages.You_do_not_have_permission')
                                             </span>
                                        @endcan
                                    </td>
                                    <td>
                                        {{$value->orders()->where('status','done')->count()}}
                                    </td>
                                    <td>

                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" value="{{$value->active ? 0 : 1}}"   @if($value->active == 1) checked @endif onclick="enableUser({{$value->id}})" id="customSwitch1{{$value->id}}">
                                                <label class="custom-control-label" for="customSwitch1{{$value->id}}">مفعل/معطل</label>
                                            </div>

                                    </td>

                                    <td> {{ $value->created_at->format('Y-m-d g:i A') }} </td>

                                    <td>

                                            <div class="btn-group mb-2">
                                                <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-chevron-down options-custom"></i>@lang('messages.operations')</button>
                                                <div class="dropdown-menu">
                                                    @can('show_users', $value)

                                                            <a class="dropdown-item" href="{{ route('admin.users.show', $value->id) }}">
                                                                @lang('messages.view')<i class="la la-eye options-style"></i>
                                                            </a>

                                                    @endcan
                                                    @can('edit_users', $value)

                                                            <a class="dropdown-item" href="{{ route('admin.users.edit', $value->id) }}">
                                                                @lang('messages.edit')<i class="la la-edit options-style"></i>
                                                            </a>


                                                            <a class="dropdown-item" href="{{ route('admin.users.post.change-password', $value->id) }}">
                                                                 @lang('messages.change_Password')<i class="la la-key options-style"></i>
                                                            </a>

                                                    @endcan

                                                        @can('activate_users', $value)

                                                                <a class="dropdown-item change_status" data="{{ $value->id }}" data_name="{{ $value->name }}" data_str="{{ $value->active ? trans('messages.Deactivate') : trans('messages.Activate')}}" data_status="{{ $value->active ? '0' : '1' }}">
                                                                    {{ $value->active ? trans('messages.Deactivate') : trans('messages.Activate') }} <i class="la la-{{ $value->active ? 'close' : 'check' }} options-style"></i>
                                                                </a>

                                                        @endcan
                                                        @can('delete_users', $value)

                                                            <a class="dropdown-item delete_data" data="{{ $value->id }}" data_name="{{$value->name  }}" >
                                                                @lang('messages.delete')<i class="la la-trash options-style"></i>
                                                            </a>

                                                        @endcan

                                                </div>
                                            </div>

                                    </td>
                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>

    <script>

        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4,5 ,7]
                    }  },
                { extend: 'excel', text: "{{trans('messages.excel')}}" ,exportOptions: {
                        columns: [ 0, 1, 2, 3 ,4,5,7]
                    }},
                { extend: 'print', text: "{{trans('messages.print')}}",exportOptions: {
                        columns: [ 0, 1, 2, 3,4,5,7 ]
                    } },
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );
        function enableUser(id){
            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');
            var data_str ='';
            if(document.getElementById('customSwitch1'+id).value == 0){
                data_str = "تم الغاء التفعيل "
            }else{
                data_str = "تم التفعيل  "
            }

            $.ajax({
                url: "{{ url('/') }}" + "/admin/users/change-status" ,
                type: "post",
                data:{_token: CSRF_TOKEN,'status' : document.getElementById('customSwitch1'+id).value , 'id' : id},
                dataType: "json",
                success:function(data) {
                    // console.log(data);
                    Swal.fire({
                        type: 'success',
                        title: data_str,
                        confirmButtonClass: 'btn-success',
                        confirmButtonText: "{{trans('messages.confirm')}}",
                    }).then((result) => {
                        location.reload();
                    });


                }
            });



        }
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.change_status', function() {

                var id = $(this).attr('data');
                var data_str = $(this).attr('data_str');
                var swal_text = '"' + $(this).attr('data_name') + '"';
                var swal_title = '{{trans('messages.Are_you_sure_of')}} '+ data_str +' العضو ؟';
                var status = $(this).attr('data_status');

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                            if (result.value) {
                                $.ajax({
                                    url: "{{ url('/') }}" + "/admin/users/change-status" ,
                                    type: "POST",
                                    data: {_token: CSRF_TOKEN, 'id': id, 'status': status, 'data_str': data_str},
                                })
                                    .done(function(reseived_data) {
                                        var parsed_data = $.parseJSON(reseived_data);

                                        if(parsed_data.code === '1'){
                                            Swal.fire({
                                                type: 'success',
                                                title:  data_str +' العضو',
                                                confirmButtonClass: 'btn-success',
                                                confirmButtonText: '{{trans('messages.confirm')}}',
                                            }).then((result) => {
                                                window.location.href = parsed_data.url;
                                            });
                                        }
                                        else{
                                            Swal.fire(
                                                "{{trans('messages.wrong_operation')}}",
                                                parsed_data.message ,
                                                "error"
                                            );
                                        }
                                    });
                            }
                        });

            });
        });
        $(document).ready(function() {

            var CSRF_TOKEN = $('meta[name="X-CSRF-TOKEN"]').attr('content');

            $('body').on('click', '.delete_data', function() {

                var id = $(this).attr('data');
                var swal_text = ' {{trans('messages.Delete')}} العضو ' + $(this).attr('data_name');
                var swal_title = '{{trans('messages.Are_you_sure_to_delete?')}}';

                Swal.fire({
                    title: swal_title,
                    text: swal_text,
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: '{{trans('messages.confirm')}}',
                    cancelButtonText: '{{trans('messages.close')}}',
                }).then((result) => {
                    console.log(result.value);
                    if (result.value) {
                        $.ajax({
                            url: "{{ url('/') }}" + "/admin/users/destroy" ,
                            type: "POST",
                            data: {_token: CSRF_TOKEN, 'id': id},
                        })
                            .done(function(reseived_data) {
                                var parsed_data = $.parseJSON(reseived_data);

                                if(parsed_data.code === '1'){
                                    Swal.fire({
                                        type: 'success',
                                        title: "{{trans('messages.Deletion_successful')}}",
                                        confirmButtonClass: 'btn-success',
                                        confirmButtonText: "{{trans('messages.confirm')}}",
                                    }).then((result) => {
                                        window.location.href = parsed_data.url;
                                    });
                                }
                                else{
                                    Swal.fire(
                                        "{{trans('messages.wrong_operation')}}",
                                        parsed_data.message ,
                                        "error"
                                    );
                                }
                            });
                    }
                });

            });
        });
    </script>
@endsection
