@extends('admin.layouts.master')

@section('title')
    طلبات الأعضاء
@endsection

@section('styles')
    <link href="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ URL::asset('admin/libs/datatables/select.bootstrap4.css') }}" rel="stylesheet" type="text/css" />
    <!-- Sweet Alert-->
    <link href="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.css') }}" rel="stylesheet" type="text/css" />
@endsection


@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.addresses.index') }}">طلبات الأعضاء</a></li>
                        <li class="breadcrumb-item active">طلبات الأعضاء</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض جميع طلبات العضو {{$user->name}}</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-4">طلبات الأعضاء</h4>

                    <table id="datatable-buttons-custom" class="table table-striped dt-responsive nowrap">
                        <thead>
                        <tr>
                            <th> # </th>
                            <th scope="col">@lang('web.image')</th>
                            <th scope="col">@lang('web.Product_name')</th>
                            <th scope="col">@lang('web.attributes')</th>

                            <th scope="col">@lang('web.price')</th>
                            <th scope="col">@lang('web.quantity')</th>
                            <th scope="col">@lang('web.Total')</th>

                        </tr>
                        </thead>

                        <tbody>
                        @if($data->count())
                            <?php $i = 0; ?>
                            @foreach( $data as $product )
                                <?php ++$i; ?>
                                <tr>
                                    <?php $value = \App\Product::find($product->product_id); ?>
                                    <td> {{ $i }} </td>
                                    <th>
                                        <div class="table-img">
                                            <img src="{{asset('uploads/products/'.$value->details()->first()->images()->first()->image)}}" class="rounded mr-1" height="60" class="rounded-circle avatar-lg img-thumbnail">
                                        </div>
                                    </th>
                                    <td><a href="{{ route('admin.products.show', $value->id) }}">{{$value->name[app()->getLocale()]}}</a></td>
                                    <td>
                                        @foreach($product->details as $key => $data)
                                            {{\App\Attribute::find($key)->name[app()->getLocale()]}} :  {{\App\Attribute::find($data)->name[app()->getLocale()]}}
                                            <br>
                                        @endforeach
                                    </td>
                                    <td>{{$product->price}} {{unserialize(\App\Currency::find($product->currency_id)->name)[app()->getLocale()]}}</td>
                                    <td>{{$product->count}}</td>
                                    <td>{{$product->price * $product->count}} {{unserialize(\App\Currency::find($product->currency_id)->name)[app()->getLocale()]}}</td>



                                </tr>

                            @endforeach
                        @endif
                        </tbody>
                    </table>
                    <div class="pagination-rounded">
                        {!! $data->render() !!}
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div>


@endsection

@section('scripts')
    <script src="{{ URL::asset('admin/libs/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.bootstrap4.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.responsive.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.flash.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.keyTable.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/datatables/dataTables.select.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ URL::asset('admin/libs/pdfmake/vfs_fonts.js') }}"></script>
    <!-- Datatables init -->
    <script src="{{ URL::asset('admin/js/pages/datatables.init.js') }}"></script>
    <script src="{{ URL::asset('admin/js/jszip.min.js') }}"></script>
    <!-- Sweet Alerts js -->
    <script src="{{ URL::asset('admin/libs/sweetalert2/sweetalert2.min.js') }}"></script>

    <!-- Sweet alert init js-->
    <script src="{{ URL::asset('admin/js/pages/sweet-alerts.init.js') }}"></script>

    <script>

        $('#datatable-buttons-custom').DataTable( {
            dom: 'Bfrtip',
            buttons: [
                { extend: 'copy', text: "{{trans('messages.copy')}}"},
                { extend: 'excel', text: "{{trans('messages.excel')}}" },
                { extend: 'print', text: "{{trans('messages.print')}}"},
            ],
            "oLanguage": {
                "sSearch": "{{trans('messages.search')}}"
            }
        } );


    </script>
@endsection
