@extends('admin.layouts.master')

@section('title')
    عرض تفاصيل العضو
@endsection



@section('page_header')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">@lang('messages.dashboard')</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.users.index') }}">الأعضاء</a></li>
                        <li class="breadcrumb-item active">عرض جميع الاعضاء</li>
                    </ol>
                </div>
                <h4 class="page-title">عرض تفاصيل العضو</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-4 col-xl-4">
            <div class="card-box text-center">

                <h4 class="mb-2"> {{ $user->name }} </h4>


                <div class="text-left mt-3">


                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.name') :</strong> <span class="ml-2">{{$user->name}}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.phone') :</strong><span class="ml-2">{{ $user->phone }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>الجنس :</strong><span class="ml-2">{{ $user->gender ? ($user->gender == "female" ? "انثى" : "ذكر" ): '---' }}</span></p>
                    <p class="text-muted mb-2 font-13"><strong>تاريخ الميلاد :</strong><span class="ml-2">{{ $user->birthday ? $user->birthday : '---' }}</span></p>

                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.email') :</strong> <span class="ml-2 ">{{ $user->email }}</span></p>
                    <p class=" mb-2 font-13"><strong>@lang('messages.Activation') :</strong>  <span class="ml-2 badge badge-pill {{ $user->active ? "badge-secondary" : "badge-light-secondary" }}">
                        {{ $user->active ? trans('messages.Activate') : trans('messages.Deactivate') }}
                    </span></p>
                    <p class="text-muted mb-2 font-13"><strong>@lang('messages.Date_added') :</strong> <span class="ml-2 badge badge-info ">{{ $user->created_at->format('Y-m-d g:i A') }}</span></p>
                </div>


            </div> <!-- end card-box -->



        </div> <!-- end col-->


    </div>

@endsection
@section('scripts')
    <script>
        $('body').addClass('page-container-bg-solid');
    </script>
@endsection
